/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class IntersectsFunction
extends GeometryFunction {
    private GeometryFunction.GeometryValue<GeometryFunction> leftParam;
    private GeometryFunction.GeometryValue<GeometryFunction> rightParam;

    public IntersectsFunction(GeometryFunction.GeometryValue<GeometryFunction> geometryValue, GeometryFunction.GeometryValue<GeometryFunction> geometryValue2) throws NullPointerException {
        if (geometryValue == null || geometryValue2 == null) {
            throw new NullPointerException("An INTERSECTS function must have two parameters different from NULL !");
        }
        this.leftParam = geometryValue;
        this.rightParam = geometryValue2;
    }

    public IntersectsFunction(IntersectsFunction intersectsFunction) throws Exception {
        this.leftParam = (GeometryFunction.GeometryValue)intersectsFunction.leftParam.getCopy();
        this.rightParam = (GeometryFunction.GeometryValue)intersectsFunction.rightParam.getCopy();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new IntersectsFunction(this);
    }

    @Override
    public String getName() {
        return "INTERSECTS";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> getLeftParam() {
        return this.leftParam;
    }

    public final void setLeftParam(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) {
        if (geometryValue != null) {
            this.leftParam = geometryValue;
        }
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> getRightParam() {
        return this.rightParam;
    }

    public final void setRightParam(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) {
        if (geometryValue != null) {
            this.rightParam = geometryValue;
        }
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.leftParam, this.rightParam};
    }

    @Override
    public int getNbParameters() {
        return 2;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n == 0) {
            return this.leftParam.getValue();
        }
        if (n == 1) {
            return this.rightParam.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove one parameter from a " + this.getName() + " function !");
        }
        if (!(aDQLOperand instanceof GeometryFunction.GeometryValue || aDQLOperand instanceof ADQLColumn || aDQLOperand instanceof GeometryFunction)) {
            throw new Exception("Impossible to replace a GeometryValue/Column/GeometryFunction by a " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
        }
        GeometryFunction.GeometryValue<GeometryFunction> geometryValue = null;
        if (n == 0) {
            geometryValue = this.leftParam;
            if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                this.leftParam = (GeometryFunction.GeometryValue)aDQLOperand;
            } else if (aDQLOperand instanceof ADQLColumn) {
                this.leftParam.setColumn((ADQLColumn)aDQLOperand);
            } else if (aDQLOperand instanceof GeometryFunction) {
                this.leftParam.setGeometry((GeometryFunction)aDQLOperand);
            }
        } else if (n == 1) {
            geometryValue = this.rightParam;
            if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                this.rightParam = (GeometryFunction.GeometryValue)aDQLOperand;
            } else if (aDQLOperand instanceof ADQLColumn) {
                this.rightParam.setColumn((ADQLColumn)aDQLOperand);
            } else if (aDQLOperand instanceof GeometryFunction) {
                this.rightParam.setGeometry((GeometryFunction)aDQLOperand);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
        }
        return geometryValue;
    }
}

